VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frm3Dtest 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "BASS - 3D Test"
   ClientHeight    =   4275
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   5415
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4275
   ScaleWidth      =   5415
   StartUpPosition =   2  'CenterScreen
   Begin VB.Frame Frame6 
      Caption         =   "Doppler factor"
      Height          =   615
      Left            =   2640
      TabIndex        =   17
      Top             =   3550
      Width           =   2655
      Begin VB.HScrollBar ID_Doppler 
         Height          =   255
         Left            =   120
         Max             =   20
         TabIndex        =   19
         Top             =   240
         Width           =   2415
      End
   End
   Begin VB.Frame Frame5 
      Caption         =   "Rolloff factor"
      Height          =   615
      Left            =   2640
      TabIndex        =   16
      Top             =   2880
      Width           =   2655
      Begin VB.HScrollBar ID_Rolloff 
         Height          =   255
         Left            =   120
         Max             =   20
         TabIndex        =   18
         Top             =   240
         Width           =   2415
      End
   End
   Begin VB.Frame Frame4 
      Height          =   2775
      Left            =   2640
      TabIndex        =   3
      Top             =   0
      Width           =   2655
      Begin VB.PictureBox picDisplay 
         FillStyle       =   0  'Solid
         Height          =   2415
         Left            =   120
         ScaleHeight     =   157
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   157
         TabIndex        =   4
         Top             =   240
         Width           =   2415
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Channels (sample/music)"
      Height          =   2415
      Left            =   120
      TabIndex        =   2
      Top             =   0
      Width           =   2415
      Begin VB.CommandButton cmdStop 
         Caption         =   "Stop"
         Enabled         =   0   'False
         Height          =   300
         Left            =   1320
         TabIndex        =   9
         Top             =   1920
         Width           =   975
      End
      Begin VB.CommandButton cmdPlay 
         Caption         =   "Play"
         Enabled         =   0   'False
         Height          =   300
         Left            =   120
         TabIndex        =   8
         Top             =   1920
         Width           =   975
      End
      Begin VB.CommandButton cmdRemove 
         Caption         =   "Remove"
         Enabled         =   0   'False
         Height          =   300
         Left            =   1320
         TabIndex        =   7
         Top             =   1560
         Width           =   975
      End
      Begin VB.CommandButton cmdAdd 
         Caption         =   "Add ..."
         Height          =   300
         Left            =   120
         TabIndex        =   6
         Top             =   1560
         Width           =   975
      End
      Begin VB.ListBox lstChannels 
         Height          =   1230
         ItemData        =   "frm3Dtest.frx":0000
         Left            =   120
         List            =   "frm3Dtest.frx":0002
         TabIndex        =   5
         Top             =   240
         Width           =   2175
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Movement"
      ClipControls    =   0   'False
      Height          =   855
      Left            =   120
      TabIndex        =   1
      Top             =   2520
      Width           =   2415
      Begin MSComDlg.CommonDialog DLG 
         Left            =   1680
         Top             =   0
         _ExtentX        =   847
         _ExtentY        =   847
         _Version        =   393216
      End
      Begin VB.OptionButton optDirection 
         Caption         =   "None"
         Height          =   255
         Index           =   4
         Left            =   1680
         TabIndex        =   14
         Top             =   450
         Value           =   -1  'True
         Width           =   700
      End
      Begin VB.OptionButton optDirection 
         Caption         =   "Back"
         Height          =   255
         Index           =   3
         Left            =   120
         TabIndex        =   13
         Top             =   450
         Width           =   735
      End
      Begin VB.OptionButton optDirection 
         Caption         =   "Front"
         Height          =   255
         Index           =   2
         Left            =   1680
         TabIndex        =   12
         Top             =   175
         Width           =   700
      End
      Begin VB.OptionButton optDirection 
         Caption         =   "Right"
         Height          =   255
         Index           =   1
         Left            =   840
         TabIndex        =   11
         Top             =   175
         Width           =   735
      End
      Begin VB.OptionButton optDirection 
         Caption         =   "Left"
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   10
         Top             =   175
         Width           =   735
      End
      Begin VB.Timer tmr3D 
         Enabled         =   0   'False
         Interval        =   50
         Left            =   2160
         Top             =   0
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "EAX Environment"
      ClipControls    =   0   'False
      Height          =   735
      Left            =   120
      TabIndex        =   0
      Top             =   3430
      Width           =   2415
      Begin VB.ComboBox cmbEAX 
         BackColor       =   &H00C0C0C0&
         Enabled         =   0   'False
         Height          =   315
         ItemData        =   "frm3Dtest.frx":0004
         Left            =   120
         List            =   "frm3Dtest.frx":0059
         TabIndex        =   15
         Text            =   "Off"
         Top             =   240
         Width           =   2175
      End
   End
End
Attribute VB_Name = "frm3Dtest"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'//////////////////////////////////////////////////////////////
' BASS 3D test,  copyright (c) 1999 Adam Hoult.
'
' Updated: 2003 by JOBnik! [Arthur Aminov, ISRAEL]
'                  e-mail: jobnik2k@hotmail.com
'
'          Added - Output Device Selector - Form
'
' originally translated from - 3dtest.c - example of Ian Luck
'//////////////////////////////////////////////////////////////
Option Explicit

Private Type channel
    channel As Long         ' The Channel
    pos As BASS_3DVECTOR    ' Position
    vel As BASS_3DVECTOR    ' Velocity
    direction As Integer    ' Direction of the channel
End Type
    
Dim chans() As channel      ' Array of channels
Dim NOFChannels As Long     ' Number of Channels
Dim chan As Long            ' Current Channel

Const TIMERPER = 50         ' Timer period (ms)
Const MAXDIST = 500         ' maximum distance of the channels (m)
Const SPEED = 5             ' Speed of the channels' movement (m/s)

Const ID_LEFT = 0
Const ID_RIGHT = 1
Const ID_FRONT = 2
Const ID_BACK = 3
Const ID_NONE = 4

Dim active As Boolean

'Display error dialogues
Sub ThrowError(ByVal Message As String)
    Call MsgBox(Message & vbCrLf & vbCrLf & "Error Code : " & BASS_ErrorGetCode, vbExclamation, "Error")
End Sub

Sub Update()
    Dim c As Integer, X As Integer, Y As Integer, cx As Integer, cy As Integer
    
    cx = picDisplay.ScaleWidth / 2
    cy = picDisplay.ScaleHeight / 2
    
    'Clear the display
    picDisplay.Cls
    
    'Draw Center Circle
    picDisplay.FillColor = RGB(100, 100, 100)
    picDisplay.Circle (cx - 4, cy - 4), 4, RGB(0, 0, 0)
    
    For c = 1 To NOFChannels
        'If the channel is playing, then update it's position
        If BASS_ChannelIsActive(chans(c).channel) = BASSTRUE Then
            'Check if channel has reached the max distance
            If chans(c).pos.z >= MAXDIST Or chans(c).pos.z <= -MAXDIST Then chans(c).vel.z = -chans(c).vel.z
            If chans(c).pos.X >= MAXDIST Or chans(c).pos.X <= -MAXDIST Then chans(c).vel.X = -chans(c).vel.X
            
            'Update channel position
            chans(c).pos.z = chans(c).pos.z + chans(c).vel.z * TIMERPER / 500
            chans(c).pos.X = chans(c).pos.X + chans(c).vel.X * TIMERPER / 500
            
            If BASS_ChannelSet3DPosition(chans(c).channel, chans(c).pos, Nothing, chans(c).vel) = BASSFALSE Then Call ThrowError("Unable to set 3d position")
        End If
        'Draw the channel position indicator
        X = cx + Int(cx * chans(c).pos.X / (MAXDIST + 40))
        Y = cy - Int(cy * chans(c).pos.z / (MAXDIST + 40))
        
        If chan = c Then
            picDisplay.FillColor = RGB(255, 0, 0)
        Else
            picDisplay.FillColor = RGB(150, 0, 0)
        End If
        picDisplay.Circle (X - 4, Y - 4), 4, RGB(0, 0, 0)
    Next c
    
    'Apply 3d changes
    BASS_Apply3D
End Sub

'Update the button states
Sub UpdateButtons()
    'Disable/enable controls depending on NOFChannels
    cmdRemove.Enabled = IIf(chan = 0, False, True)
    cmdPlay.Enabled = IIf(chan = 0, False, True)
    cmdStop.Enabled = IIf(chan = 0, False, True)
    
    Dim i As Integer
    
    For i = 0 To 4
        optDirection(i).Enabled = IIf(chan = 0, False, True)
    Next i
    
    If chan > 0 Then optDirection(chans(chan).direction).value = True
End Sub

Private Sub cmbEAX_Click()
    'Change the EAX Environment depending on which is selected
    Select Case cmbEAX.ListIndex
        Case 0: BASS_SetEAXParameters -1, 0, -1, -1
        Case 1: BASS_SetEAXPreset EAX_ENVIRONMENT_GENERIC
        Case 2: BASS_SetEAXPreset EAX_ENVIRONMENT_PADDEDCELL
        Case 3: BASS_SetEAXPreset EAX_ENVIRONMENT_ROOM
        Case 4: BASS_SetEAXPreset EAX_ENVIRONMENT_BATHROOM
        Case 5: BASS_SetEAXPreset EAX_ENVIRONMENT_LIVINGROOM
        Case 6: BASS_SetEAXPreset EAX_ENVIRONMENT_STONEROOM
        Case 7: BASS_SetEAXPreset EAX_ENVIRONMENT_AUDITORIUM
        Case 8: BASS_SetEAXPreset EAX_ENVIRONMENT_CONCERTHALL
        Case 9: BASS_SetEAXPreset EAX_ENVIRONMENT_CAVE
        Case 10: BASS_SetEAXPreset EAX_ENVIRONMENT_ARENA
        Case 11: BASS_SetEAXPreset EAX_ENVIRONMENT_HANGAR
        Case 12: BASS_SetEAXPreset EAX_ENVIRONMENT_CARPETEDHALLWAY
        Case 13: BASS_SetEAXPreset EAX_ENVIRONMENT_HALLWAY
        Case 14: BASS_SetEAXPreset EAX_ENVIRONMENT_STONECORRIDOR
        Case 15: BASS_SetEAXPreset EAX_ENVIRONMENT_ALLEY
        Case 16: BASS_SetEAXPreset EAX_ENVIRONMENT_FOREST
        Case 17: BASS_SetEAXPreset EAX_ENVIRONMENT_CITY
        Case 18: BASS_SetEAXPreset EAX_ENVIRONMENT_MOUNTAINS
        Case 19: BASS_SetEAXPreset EAX_ENVIRONMENT_QUARRY
        Case 20: BASS_SetEAXPreset EAX_ENVIRONMENT_PLAIN
        Case 21: BASS_SetEAXPreset EAX_ENVIRONMENT_PARKINGLOT
        Case 22: BASS_SetEAXPreset EAX_ENVIRONMENT_SEWERPIPE
        Case 23: BASS_SetEAXPreset EAX_ENVIRONMENT_UNDERWATER
        Case 24: BASS_SetEAXPreset EAX_ENVIRONMENT_DRUGGED
        Case 25: BASS_SetEAXPreset EAX_ENVIRONMENT_DIZZY
        Case 26: BASS_SetEAXPreset EAX_ENVIRONMENT_PSYCHOTIC
    End Select
End Sub

Private Sub cmdAdd_Click()
    On Error Resume Next
  
    Dim newchan As Long
    
    DLG.FileName = ""
    DLG.CancelError = True
    DLG.flags = cdlOFNExplorer Or cdlOFNFileMustExist Or cdlOFNHideReadOnly
    DLG.Filter = "MOD Music/Sample Files (wav/xm/mod/s3m/it/mtm)|*.wav;*.xm;*.mod;*.s3m;*.it;*.mtm|All Files (*.*)|*.*|"
    DLG.ShowOpen
    
    'if cancel was pressed, exit the procedure
    If Err.Number = 32755 Then Exit Sub
    
    ' Load a music from "file" with 3D enabled, and make it loop & use ramping
    newchan = BASS_MusicLoad(BASSFALSE, DLG.FileName, 0, 0, BASS_MUSIC_RAMP Or BASS_MUSIC_LOOP Or BASS_SAMPLE_3D, 0)
    
    If newchan <> 0 Then
        NOFChannels = NOFChannels + 1
        ReDim Preserve chans(NOFChannels)
        chans(NOFChannels).channel = newchan
        chans(NOFChannels).direction = ID_NONE
        lstChannels.AddItem DLG.FileName
        'Set the min distance to 35 meters
        Call BASS_ChannelSet3DAttributes(newchan, -1, 35, -1, -1, -1, -1)
    Else
        'Load a sample from "file" with 3D enabled, and make it loop */
        newchan = BASS_SampleLoad(BASSFALSE, DLG.FileName, 0, 0, 1, BASS_SAMPLE_LOOP Or BASS_SAMPLE_3D)

        If newchan <> 0 Then
            Dim sam As BASS_SAMPLE
            NOFChannels = NOFChannels + 1
            ReDim Preserve chans(NOFChannels)
            chans(NOFChannels).channel = newchan
            chans(NOFChannels).direction = ID_NONE
            lstChannels.AddItem DLG.FileName
            'get the info
            Call BASS_SampleGetInfo(newchan, sam)
            'Set the min distance to 35 meters
            sam.mindist = 35
            'Set the max distance to 500 meters
            sam.MAXDIST = 500
            Call BASS_SampleSetInfo(newchan, sam)
        Else
            Call ThrowError("Can't load file")
        End If
    End If
End Sub

'Play the select sample/music
Private Sub cmdPlay_Click()
    Call BASS_SamplePlay3D(chans(chan).channel, chans(chan).pos, Nothing, chans(chan).vel)
    Call BASS_MusicPlay(chans(chan).channel)
End Sub

Private Sub cmdRemove_Click()
    BASS_SampleFree chans(chan).channel
    BASS_MusicFree chans(chan).channel
    
    'remove the item from the array
    Dim TempChans() As channel, Counter As Integer
    ReDim TempChans(NOFChannels)
    
    Counter = 0
    
    Dim i As Integer
    
    For i = 1 To NOFChannels
        If i <> chan Then
            Counter = Counter + 1
            TempChans(Counter) = chans(i)
        End If
    Next i
    
    NOFChannels = NOFChannels - 1
    
    ReDim chans(NOFChannels)
    
    For i = 1 To NOFChannels
        chans(i) = TempChans(i)
    Next i
    
    Erase TempChans
    
    lstChannels.RemoveItem lstChannels.ListIndex
    chan = 0
    Call UpdateButtons
End Sub

'stop playing music/sample
Private Sub cmdStop_Click()
    Call BASS_ChannelStop(chans(chan).channel)
End Sub

Private Sub Form_Load()
    'change and set the current path
    'so it won't ever tell you that bass.dll is not found
    ChDrive App.Path
    ChDir App.Path
    
    'check if 'bass.dll' is exists
    If Not FileExists(RPP(App.Path) & "bass.dll") Then
        MsgBox "BASS.DLL does not exists", vbCritical, "BASS.DLL"
        End
    End If

    'Check that BASS 2.0 was loaded
    If BASS_GetVersion <> MakeLong(2, 0) Then
        Call ThrowError("BASS version 2.0 was not loaded")
    End If
    
    cmbEAX.ListIndex = 0
    DLG.InitDir = App.Path
    
    ID_Rolloff.max = 20
    ID_Rolloff.value = 10
    ID_Doppler.max = 20
    ID_Doppler.value = 10
End Sub

Private Sub Form_Activate()
    If (Not active) Then
        frmDevice.Show vbModal, Me
        'Initialize output device - default device, 44100hz, stereo, 16 bits, with 3D funtionality
        If BASS_Init(frmDevice.device, 44100, BASS_DEVICE_3D, Me.hWnd, 0) = BASSFALSE Then
            Call ThrowError("Can't initialize output device")
        End If
        
        'Use meters as distance unit, 2x real world rolloff, real doppler effect
        Call BASS_Set3DFactors(1, 2, 1)
        
        'Turn EAX off (volume=0.0), if error then EAX is not supported
        If BASS_SetEAXParameters(-1, 0, -1, -1) Then cmbEAX.Enabled = True
        
        Call UpdateButtons
        tmr3D.Enabled = True
    End If
    
    active = True
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    Call BASS_Free
    Erase chans
End Sub

Private Sub ID_Doppler_Scroll()
    'Change the doppler factor
    Call BASS_Set3DFactors(-1#, -1#, pow(2#, (ID_Doppler.value - 10) / 6#))
End Sub

Private Sub ID_Rolloff_Scroll()
    'Change the rolloff factor
    Call BASS_Set3DFactors(-1#, pow(2#, (ID_Rolloff.value - 10) / 6#), -1#)
End Sub

Private Sub lstChannels_Click()
    'Change the selected channel
    chan = lstChannels.ListIndex + 1
    If chan < 0 Then chan = 0
    Call UpdateButtons
End Sub

Private Sub optDirection_Click(index As Integer)
    Select Case index
        Case ID_LEFT
            chans(chan).direction = ID_LEFT
            ' Make the channel move past the left of you
            ' Set speed in m/s
            chans(chan).vel.z = SPEED * 500 / TIMERPER
            chans(chan).vel.X = 0
            ' Set positon to the left
            chans(chan).pos.X = -20
        Case ID_RIGHT
            chans(chan).direction = ID_RIGHT
            ' Make the channel move past the Right of you
            chans(chan).vel.z = SPEED * 500 / TIMERPER
            chans(chan).vel.X = 0
            ' Set positon to the Right
            chans(chan).pos.X = 20
        Case ID_FRONT
            chans(chan).direction = ID_FRONT
            ' Make the channel move past the front of you
            chans(chan).vel.X = SPEED * 500 / TIMERPER
            chans(chan).vel.z = 0
            ' Set positon to the front
            chans(chan).pos.z = 20
        Case ID_BACK
            chans(chan).direction = ID_BACK
            ' Make the channel move past the back of you
            chans(chan).vel.X = SPEED * 500 / TIMERPER
            chans(chan).vel.z = 0
            ' Set positon to the back
            chans(chan).pos.z = -20
        Case ID_NONE
            chans(chan).direction = ID_NONE
            ' Make the channel stop moving
            chans(chan).vel.z = 0
            chans(chan).vel.X = 0
    End Select
End Sub

Private Sub tmr3D_Timer()
    Call Update
End Sub

'-------------------------------------------------
'some useful functions :)
'-------------------------------------------------

'Calculate power of
Public Function pow(i As Integer, j As Integer) As Long
   Dim index As Integer
   
   pow = 1
   For index = j To 1 Step -1
       pow = pow * i
   Next
End Function

'check if any file exists
Public Function FileExists(ByVal FileName As String) As Boolean
    On Local Error Resume Next
    FileExists = (Dir$(FileName) <> "")
End Function

' RPP = Return Proper Path
Public Function RPP(ByVal fp As String) As String
    RPP = IIf(Mid(fp, Len(fp), 1) = "\", fp, fp & "\")
End Function

'get file name from file path
Public Function GetFileName(ByVal fp As String) As String
    GetFileName = Mid(fp, InStrRev(fp, "\") + 1)
End Function
